//
//  NSURL+MPAdditions.m
//  dJAX
//
//  Copyright (c) 2013 dJAX. All rights reserved.
//

#import "NSURL+MPAdditions.h"

static NSString * const kTelephoneScheme = @"tel";
static NSString * const kTelephonePromptScheme = @"telprompt";

// Share Constants
static NSString * const kdJAXShareScheme = @"mopubshare";
static NSString * const kdJAXShareTweetHost = @"tweet";

// Commands Constants
static NSString * const kdJAXURLScheme = @"mopub";
static NSString * const kdJAXCloseHost = @"close";
static NSString * const kdJAXFinishLoadHost = @"finishLoad";
static NSString * const kdJAXFailLoadHost = @"failLoad";
static NSString * const kdJAXPrecacheCompleteHost = @"precacheComplete";
static NSString * const kdJAXRewardedVideoEndedHost = @"rewardedVideoEnded";

@implementation NSURL (MPAdditions)

- (NSString *)mp_queryParameterForKey:(NSString *)key
{
    NSArray *queryElements = [self.query componentsSeparatedByString:@"&"];
    for (NSString *element in queryElements) {
        NSArray *keyAndValue = [element componentsSeparatedByString:@"="];
        if (keyAndValue.count >= 2 &&
            [[keyAndValue objectAtIndex:0] isEqualToString:key] &&
            [[keyAndValue objectAtIndex:1] length] > 0) {
            return [[keyAndValue objectAtIndex:1] stringByReplacingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
        }
    }
    return nil;
}

- (NSArray *)mp_queryParametersForKey:(NSString *)key
{
    NSMutableArray *matchingParameters = [NSMutableArray array];
    NSArray *queryElements = [self.query componentsSeparatedByString:@"&"];
    for (NSString *element in queryElements) {
        NSArray *keyAndValue = [element componentsSeparatedByString:@"="];
        if (keyAndValue.count >= 2 &&
            [[keyAndValue objectAtIndex:0] isEqualToString:key] &&
            [[keyAndValue objectAtIndex:1] length] > 0) {
            [matchingParameters addObject:[[keyAndValue objectAtIndex:1] stringByReplacingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
        }
    }
    return [NSArray arrayWithArray:matchingParameters];
}

- (NSDictionary *)mp_queryAsDictionary
{
    NSMutableDictionary *queryDict = [NSMutableDictionary dictionary];
    NSArray *queryElements = [self.query componentsSeparatedByString:@"&"];
    for (NSString *element in queryElements) {
        NSArray *keyVal = [element componentsSeparatedByString:@"="];
        if (keyVal.count >= 2) {
            NSString *key = [keyVal objectAtIndex:0];
            NSString *value = [keyVal objectAtIndex:1];
            [queryDict setObject:[value stringByReplacingPercentEscapesUsingEncoding:NSUTF8StringEncoding]
                          forKey:key];
        }
    }
    return queryDict;
}

- (BOOL)mp_hasTelephoneScheme
{
    return [[[self scheme] lowercaseString] isEqualToString:kTelephoneScheme];
}

- (BOOL)mp_hasTelephonePromptScheme
{
    return [[[self scheme] lowercaseString] isEqualToString:kTelephonePromptScheme];
}

- (BOOL)mp_isSafeForLoadingWithoutUserAction
{
    return [[self scheme].lowercaseString isEqualToString:@"http"] ||
        [[self scheme].lowercaseString isEqualToString:@"https"] ||
        [[self scheme].lowercaseString isEqualToString:@"about"];
}

- (BOOL)mp_isdJAXScheme
{
    return [[self scheme] isEqualToString:kdJAXURLScheme];
}

- (MPdJAXShareHostCommand)mp_dJAXShareHostCommand
{
    NSString *host = [self host];
    if (![self mp_isdJAXShareScheme]) {
        return MPdJAXShareHostCommandUnrecognized;
    } else if ([host isEqualToString:kdJAXShareTweetHost]) {
        return MPdJAXShareHostCommandTweet;
    } else {
        return MPdJAXShareHostCommandUnrecognized;
    }
}

- (MPdJAXHostCommand)mp_dJAXHostCommand
{
    NSString *host = [self host];
    if (![self mp_isdJAXScheme]) {
        return MPdJAXHostCommandUnrecognized;
    } else if ([host isEqualToString:kdJAXCloseHost]) {
        return MPdJAXHostCommandClose;
    } else if ([host isEqualToString:kdJAXFinishLoadHost]) {
        return MPdJAXHostCommandFinishLoad;
    } else if ([host isEqualToString:kdJAXFailLoadHost]) {
        return MPdJAXHostCommandFailLoad;
    } else if ([host isEqualToString:kdJAXPrecacheCompleteHost]) {
        return MPdJAXHostCommandPrecacheComplete;
    } else if ([host isEqualToString:kdJAXRewardedVideoEndedHost]) {
        return MPdJAXHostCommandRewardedVideoEnded;
    } else {
        return MPdJAXHostCommandUnrecognized;
    }
}

- (BOOL)mp_isdJAXShareScheme
{
    return [[self scheme] isEqualToString:kdJAXShareScheme];
}

@end
